/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.world;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.storage.ISpawnWorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.matrix.VecOrigin;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.world.CreativeWorld;
import team.creative.creativecore.common.world.FakeWorldInfo;

public class FakeWorld
extends CreativeWorld {
    public MinecraftServer server;
    public IVecOrigin origin;
    private final Scoreboard scoreboard = new Scoreboard();
    private DimensionRenderInfo renderInfo;
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender;

    public static FakeWorld createFakeWorld(MinecraftServer server, String name, boolean client) {
        FakeWorldInfo info = new FakeWorldInfo(Difficulty.PEACEFUL, false, true);
        if (!client) {
            return new FakeWorld(info, 6, () -> ((MinecraftServer)server).func_213185_aS(), false, false, 0L);
        }
        return FakeWorld.createFakeWorldClient(name, info, 6);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static FakeWorld createFakeWorldClient(String name, FakeWorldInfo info, int radius) {
        return new FakeWorld(info, radius, () -> ((Minecraft)Minecraft.func_71410_x()).func_213239_aq(), true, false, 0L);
    }

    protected FakeWorld(ISpawnWorldInfo worldInfo, int radius, Supplier<IProfiler> supplier, boolean client, boolean debug, long seed) {
        super(worldInfo, radius, supplier, client, debug, seed);
        if (client) {
            this.renderInfo = DimensionRenderInfo.func_243495_a((DimensionType)this.func_230315_m_());
        }
    }

    @Override
    public IVecOrigin getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Vec3d vec) {
        this.origin = new VecOrigin(vec);
    }

    @Override
    public boolean hasParent() {
        return false;
    }

    @Override
    public World getParent() {
        return null;
    }

    @Override
    public World getRealWorld() {
        return null;
    }

    public Biome func_225604_a_(int p_225604_1_, int p_225604_2_, int p_225604_3_) {
        return (Biome)this.func_241828_r().func_243612_b(Registry.field_239720_u_).func_243576_d(Biomes.field_76772_c);
    }

    public float func_230487_a_(Direction p_230487_1_, boolean p_230487_2_) {
        boolean flag = this.renderInfo.func_239217_c_();
        if (!p_230487_2_) {
            return flag ? 0.9f : 1.0f;
        }
        switch (p_230487_1_) {
            case DOWN: {
                return flag ? 0.9f : 0.5f;
            }
            case UP: {
                return flag ? 0.9f : 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    public void func_184148_a(PlayerEntity p_184148_1_, double p_184148_2_, double p_184148_4_, double p_184148_6_, SoundEvent p_184148_8_, SoundCategory p_184148_9_, float p_184148_10_, float p_184148_11_) {
    }

    public void func_217384_a(PlayerEntity p_217384_1_, Entity p_217384_2_, SoundEvent p_217384_3_, SoundCategory p_217384_4_, float p_217384_5_, float p_217384_6_) {
    }

    public Scoreboard func_96441_U() {
        return this.scoreboard;
    }

    public RecipeManager func_199532_z() {
        if (this.field_72995_K) {
            return Minecraft.func_71410_x().func_147114_u().func_199526_e();
        }
        return this.func_73046_m().func_199529_aN();
    }

    public ITagCollectionSupplier func_205772_D() {
        if (this.field_72995_K) {
            return Minecraft.func_71410_x().func_147114_u().func_199724_l();
        }
        return this.func_73046_m().func_244266_aF();
    }

    public void func_217378_a(PlayerEntity p_217378_1_, int p_217378_2_, BlockPos p_217378_3_, int p_217378_4_) {
    }

    public DynamicRegistries func_241828_r() {
        if (this.field_72995_K) {
            return Minecraft.func_71410_x().func_147114_u().func_239165_n_();
        }
        return this.func_73046_m().func_244267_aX();
    }
}

